/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.mobs;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.colonyEvents.IColonyCampFireRaidEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.enchants.ModEnchants;
import com.minecolonies.api.entity.CustomGoalSelector;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.combat.CombatAIStates;
import com.minecolonies.api.entity.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.combat.threat.ThreatTable;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.entity.mobs.RaiderType;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.entity.pathfinding.IStuckHandlerEntity;
import com.minecolonies.api.entity.pathfinding.PathingStuckHandler;
import com.minecolonies.api.entity.pathfinding.registry.IPathNavigateRegistry;
import com.minecolonies.api.items.IChiefSwordItem;
import com.minecolonies.api.sounds.RaiderSounds;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.RaiderConstants;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityMinecoloniesMob
extends MobEntity
implements IStuckHandlerEntity,
IThreatTableEntity,
IMob {
    private static final double TEAM_DIFFICULTY = 2.0;
    private static final float HP_PERCENT_PER_DMG = 0.03f;
    private static final int MAX_SCALED_DAMAGE = 7;
    private static final float MIN_THORNS_DAMAGE = 30.0f;
    private static final int THORNS_CHANCE = 5;
    private AbstractAdvancedPathNavigate newNavigator;
    private IColony colony;
    private int currentCount = 0;
    private long worldTimeAtSpawn = 0L;
    private int currentTick = 0;
    private int stuckCounter = 1;
    private int ladderCounter = 0;
    private int eventID = 0;
    private boolean isRegistered = false;
    private int invulTime = 40;
    private int envDmgCooldown = 0;
    private int envDamageInterval = 5;
    private boolean envDamageImmunity = false;
    private int collisionCounter = 0;
    private boolean canBeStuck = true;
    private static final int COLL_THRESHOLD = 50;
    private static final String RAID_TEAM = "RAIDERS_TEAM";
    private double difficulty = 1.0;
    private ThreatTable threatTable = new ThreatTable<AbstractEntityMinecoloniesMob>(this);
    private ITickRateStateMachine<IState> ai = new TickRateStateMachine<CombatAIStates>(CombatAIStates.NO_TARGET, e -> Log.getLogger().warn(e));

    public AbstractEntityMinecoloniesMob(EntityType<? extends AbstractEntityMinecoloniesMob> type, World world) {
        super(type, world);
        this.worldTimeAtSpawn = world.func_82737_E();
        this.func_110163_bv();
        this.field_70714_bg = new CustomGoalSelector(this.field_70714_bg);
        this.field_70715_bh = new CustomGoalSelector(this.field_70715_bh);
        this.field_70728_aV = 5;
        IMinecoloniesAPI.getInstance().getMobAIRegistry().applyToMob(this);
        this.func_184224_h(true);
        RaiderMobUtils.setEquipment(this);
    }

    public void func_70108_f(@NotNull Entity entityIn) {
        if (this.invulTime > 0 || (this.collisionCounter += 3) > 50) {
            return;
        }
        super.func_70108_f(entityIn);
    }

    public void func_70642_aH() {
        super.func_70642_aH();
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null && this.field_70170_p.field_73012_v.nextInt(100) <= 1) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return this.shouldDespawn() || this.field_70170_p != null && this.field_70170_p.isAreaLoaded(this.func_233580_cy_(), 3) && this.getColony() == null;
    }

    public abstract RaiderType getRaiderType();

    private boolean shouldDespawn() {
        return this.worldTimeAtSpawn != 0L && this.field_70170_p.func_82737_E() - this.worldTimeAtSpawn >= 36000L;
    }

    @NotNull
    public AbstractAdvancedPathNavigate getNavigation() {
        if (this.newNavigator == null) {
            this.newNavigator = IPathNavigateRegistry.getInstance().getNavigateFor(this);
            this.field_70699_by = this.newNavigator;
            this.newNavigator.func_212239_d(true);
            this.newNavigator.setSwimSpeedFactor(this.getSwimSpeedFactor());
            this.newNavigator.func_189566_q().func_186317_a(true);
            this.newNavigator.getPathingOptions().withDropCost(1.3);
            PathingStuckHandler stuckHandler = PathingStuckHandler.createStuckHandler().withTakeDamageOnStuck(0.4f).withBuildLeafBridges().withPlaceLadders();
            if (((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().doBarbariansBreakThroughWalls.get()).booleanValue()) {
                stuckHandler.withBlockBreaks();
                stuckHandler.withCompleteStuckBlockBreak(6);
            }
            this.newNavigator.setStuckHandler(stuckHandler);
        }
        return this.newNavigator;
    }

    public abstract double getSwimSpeedFactor();

    public int getStuckCounter() {
        return this.stuckCounter;
    }

    public void setStuckCounter(int stuckCounter) {
        this.stuckCounter = stuckCounter;
    }

    public int getLadderCounter() {
        return this.ladderCounter;
    }

    public void setLadderCounter(int ladderCounter) {
        this.ladderCounter = ladderCounter;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return RaiderSounds.raiderSounds.get((Object)this.getRaiderType()).get((Object)RaiderSounds.RaiderSoundTypes.HURT);
    }

    protected SoundEvent func_184615_bR() {
        return RaiderSounds.raiderSounds.get((Object)this.getRaiderType()).get((Object)RaiderSounds.RaiderSoundTypes.DEATH);
    }

    @javax.annotation.Nullable
    protected SoundEvent func_184639_G() {
        return RaiderSounds.raiderSounds.get((Object)this.getRaiderType()).get((Object)RaiderSounds.RaiderSoundTypes.SAY);
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74772_a("time", this.worldTimeAtSpawn);
        compound.func_74768_a("stuck", this.stuckCounter);
        compound.func_74768_a("ladder", this.ladderCounter);
        compound.func_74768_a("colony", this.colony == null ? 0 : this.colony.getID());
        compound.func_74768_a("mc_event_id", this.eventID);
        super.func_213281_b(compound);
    }

    @javax.annotation.Nullable
    public Entity changeDimension(@NotNull ServerWorld serverWorld, @NotNull ITeleporter teleporter) {
        return null;
    }

    public void func_70037_a(CompoundNBT compound) {
        int colonyId;
        this.worldTimeAtSpawn = compound.func_74763_f("time");
        this.stuckCounter = compound.func_74762_e("stuck");
        this.ladderCounter = compound.func_74762_e("ladder");
        this.eventID = compound.func_74762_e("mc_event_id");
        if (compound.func_74764_b("colony") && (colonyId = compound.func_74762_e("colony")) != 0) {
            this.setColony(IColonyManager.getInstance().getColonyByWorld(colonyId, this.field_70170_p));
        }
        if (this.colony == null || this.eventID == 0) {
            this.func_70106_y();
        }
        super.func_70037_a(compound);
    }

    public void func_70636_d() {
        this.func_82168_bl();
        if (this.invulTime > 0) {
            --this.invulTime;
        } else {
            this.func_184224_h(false);
        }
        if (this.collisionCounter > 0) {
            --this.collisionCounter;
        }
        if (this.field_70170_p.field_72995_K) {
            super.func_70636_d();
            return;
        }
        if (this.currentTick % (this.field_70146_Z.nextInt(20) + 1) == 0) {
            if (this.worldTimeAtSpawn == 0L) {
                this.worldTimeAtSpawn = this.field_70170_p.func_82737_E();
            }
            if (this.shouldDespawn()) {
                this.func_70645_a(new DamageSource("despawn"));
                this.func_70106_y();
                return;
            }
            if (!this.isRegistered) {
                this.registerWithColony();
            }
            if (this.currentCount <= 0) {
                this.currentCount = 960;
                if (!this.func_184614_ca().func_190926_b() && RaiderConstants.SPEED_EFFECT != null && this.func_184614_ca().func_77973_b() instanceof IChiefSwordItem && (Integer)MinecoloniesAPIProxy.getInstance().getConfig().getServer().barbarianHordeDifficulty.get() >= 5) {
                    RaiderMobUtils.getBarbariansCloseToEntity((Entity)this, 7.0).stream().filter(entity -> !entity.func_70644_a(Effects.field_76424_c)).forEach(entity -> entity.func_195064_c(new EffectInstance(Effects.field_76424_c, 60, 1)));
                }
            } else {
                --this.currentCount;
            }
        }
        ++this.currentTick;
        if (this.isRegistered) {
            this.ai.tick();
        }
        super.func_70636_d();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        RaiderMobUtils.setEquipment(this);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K && this.colony != null && this.eventID > 0) {
            this.colony.getEventManager().unregisterEntity((Entity)this, this.eventID);
        }
        super.func_70106_y();
    }

    public IColony getColony() {
        return this.colony;
    }

    public void registerWithColony() {
        if (this.colony == null || this.eventID == 0 || this.field_70729_aU) {
            this.func_70106_y();
            return;
        }
        RaiderMobUtils.setMobAttributes(this, this.getColony());
        this.colony.getEventManager().registerEntity((Entity)this, this.eventID);
        this.isRegistered = true;
    }

    public void func_70645_a(@NotNull DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.getColony() != null) {
            this.getColony().getEventManager().onEntityDeath((LivingEntity)this, this.eventID);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_70097_a(@NotNull DamageSource damageSource, float damage) {
        if (damageSource.func_76346_g() instanceof LivingEntity && !(damageSource.func_76346_g() instanceof AbstractEntityMinecoloniesMob)) {
            this.threatTable.addThreat((LivingEntity)damageSource.func_76346_g(), (int)damage);
        }
        if (damageSource.func_76364_f() == null) {
            if (this.envDamageImmunity) {
                return false;
            }
            if (--this.envDmgCooldown > 0) return false;
            this.envDmgCooldown = this.envDamageInterval;
            return super.func_70097_a(damageSource, damage);
        } else {
            Entity source;
            if (this.field_70170_p.func_201670_d()) return super.func_70097_a(damageSource, damage);
            IColonyEvent event = this.colony.getEventManager().getEventByID(this.eventID);
            if (event instanceof IColonyCampFireRaidEvent) {
                ((IColonyCampFireRaidEvent)((Object)event)).setCampFireTime(0);
            }
            if (!((source = damageSource.func_76346_g()) instanceof PlayerEntity)) return super.func_70097_a(damageSource, damage);
            if (damage > 30.0f && this.field_70146_Z.nextInt(5) == 0) {
                source.func_70097_a(DamageSource.func_92087_a((Entity)this), damage * 0.5f);
            }
            float raiderDamageEnchantLevel = EnchantmentHelper.func_77506_a((Enchantment)ModEnchants.raiderDamage, (ItemStack)((PlayerEntity)source).func_184614_ca());
            float baseScalingDamage = Math.min(damage, 7.0f);
            float totalWithScaled = Math.max(damage, damage - baseScalingDamage + baseScalingDamage * 0.03f * this.func_110138_aP() * (1.0f + raiderDamageEnchantLevel / 5.0f));
            return super.func_70097_a(damageSource, totalWithScaled);
        }
    }

    public static AttributeModifierMap.MutableAttribute getDefaultAttributes() {
        return LivingEntity.func_233639_cI_().func_233814_a_(RaiderMobUtils.MOB_ATTACK_DAMAGE).func_233814_a_(Attributes.field_233818_a_).func_233814_a_(Attributes.field_233826_i_).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233819_b_, 70.0).func_233815_a_(Attributes.field_233823_f_, Attributes.field_233823_f_.func_111110_b());
    }

    public void setColony(IColony colony) {
        if (colony != null) {
            this.colony = colony;
        }
    }

    public int getEventID() {
        return this.eventID;
    }

    public void setEventID(int eventID) {
        this.eventID = eventID;
    }

    public void setEnvDamageInterval(int interval) {
        this.envDamageInterval = interval;
    }

    public void setEnvDamageImmunity(boolean immunity) {
        this.envDamageImmunity = immunity;
    }

    public void initStatsFor(double baseHealth, double difficulty, double baseDamage) {
        this.func_110148_a(RaiderMobUtils.MOB_ATTACK_DAMAGE).func_111128_a(baseDamage);
        this.difficulty = difficulty;
        double armor = difficulty * 1.0;
        this.func_110148_a(Attributes.field_233826_i_).func_111128_a(armor);
        this.setEnvDamageInterval((int)(2.0 * difficulty));
        if (difficulty >= 1.4) {
            this.setEnvDamageImmunity(true);
        }
        if (difficulty >= 2.0) {
            this.field_70170_p.func_96441_U().func_197901_a(this.func_195047_I_(), this.checkOrCreateTeam());
        }
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(baseHealth);
        this.func_70606_j(this.func_110138_aP());
    }

    private ScorePlayerTeam checkOrCreateTeam() {
        if (this.field_70170_p.func_96441_U().func_96508_e(this.getTeamName()) == null) {
            this.field_70170_p.func_96441_U().func_96527_f(this.getTeamName());
            this.field_70170_p.func_96441_U().func_96508_e(this.getTeamName()).func_96660_a(false);
        }
        return this.field_70170_p.func_96441_U().func_96508_e(this.getTeamName());
    }

    protected String getTeamName() {
        return RAID_TEAM;
    }

    public double getDifficulty() {
        return this.difficulty;
    }

    @Override
    public boolean canBeStuck() {
        return this.canBeStuck;
    }

    public void setCanBeStuck(boolean canBeStuck) {
        this.canBeStuck = canBeStuck;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_203004_j(boolean down) {
    }

    @Override
    public ThreatTable getThreatTable() {
        return this.threatTable;
    }

    public ITickRateStateMachine<IState> getAI() {
        return this.ai;
    }
}

